#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Magnetic Field LinesMod01.fsh  by   adasba 
//https://www.shadertoy.com/view/3lcXR4
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//I didn't make this. Credit to:
//https://gist.github.com/yiwenl/745bfea7f04c456e0101
vec3 hsv2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

//I didn't make this either. Credit to:
//https://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


const int pointCount = 32;
    
#define PI 3.1415926535897932384626433832795
    
vec2 magneticField(vec3[pointCount] pts, vec2 position) {
    vec2 netForce = vec2(0, 0);
    for (int i = 0; pointCount > i; i++) {
    	netForce += (position - pts[i].xy) / pow(distance(position, pts[i].xy), 3.0) * pts[i].z;
    }
    return netForce;
}

float modsign(float a, float b) {
	return mod(a, b) * sign(a);
}

vec3 points[pointCount];


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    
    vec2 m = vec2(iMouse.x / iResolution.x, iMouse.y / iResolution.y);
    
    for (int i = 0; pointCount > i; i++) {
        int pc = pointCount;
    	points[i] = vec3(0.0);
        points[i].x = rand(vec2(i, i + pc)) + sin(iTime * rand(vec2(i + pc * 5, i + pc * 6)) * 0.25) * 0.6;
        points[i].y = rand(vec2(i + pc * 2, i + pc * 3)) + sin(iTime * rand(vec2(i + pc * 7, i + pc * 8)) * 0.25) * 0.6;
        points[i].z = rand(vec2(i + pc * 4)) * 2.0 - 1.0;
    }
    
    points[1].x = m.x;
    points[1].y = m.y;
    points[1].z = -1.0;
    
    //points[0] = vec3(0.25, 0.25, 1.0);
    
    //points[2] = vec3(0.75, 0.75, 1.0);
	//points[1] = vec3(m.x, m.y, -1.0);
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;

    // Time varying pixel color
    //vec3 col = 0.5 + 0.5*cos(iTime+uv.xyx+vec3(0,2,4));

    // Output to screen
    //fragColor = vec4(col,1.0);
    
    vec2 mField = magneticField(points, uv);
    float fieldMag = distance(vec2(0, 0), mField);
    float fieldDir = atan(mField.y, mField.x);
    //fragColor = vec4(log(fieldMag * 5.2) * 0.2, fieldDir / (2.0 * PI) + 0.5, 0.0, 1.0);
    vec2 mDeriv = mField - magneticField(points, uv + vec2(0.0001));
    
    //fragColor = vec4(hsv2rgb(vec3(fieldDir / (PI * 2.0), 1.0, log(fieldMag * 20.0) * 0.1)), 1.0);
    float logmag = log(fieldMag);
    //float threshold = (1.0 / (1.0 + pow(3.0, -logmag)));
    float threshold = pow(distance(vec2(0.0), mDeriv), 0.33);//pow((pow(2.0, 0.333) / (1.0 + pow(2.0, -distance(vec2(0.0), mDeriv)))), 3.0);
    //vec3 col = vec3((mod(logmag * 4.0, 2.0) > threshold * 0.5) ? 0.0 : 1.0);
    float col = (mod(fieldDir / PI * 24.0, 2.0) > threshold * 0.5) ? 0.0 : 1.0;
    fragColor = vec4(hsv2rgb(vec3(fieldDir / (PI * 2.0), 1.0, col)), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

